clear all;
close all;
clc;

% extremum seeking control of state feedback linearizable nonlinear system
% steepest-decsent algorithm based schemes

% define the global variable
global A B InvWc x0 xs t0 t1 K N; 
global STABLE;  
global usave tsave

usave=[]; tsave=[];


% Consider a state feedback linearizable nonlinear systemes
% x1dot=-x1+x2
% x2dot=x1x2+u
%
% After feedback linearzation, the resulting system will behave as
% following (A,B) in terms of new state z

% stable system matrix
A=[0 1; -2 -3];
B=[0;  1];  
STABLE=1;  

icon=1; % Choice of cost function 
        % 0 --- J(x)=5 x_1^2 + x_2^2 + 4x_1x_2-14x_1-6x_2+20.
        % 1 --- Banana Function
t0=0;  % start time
t1=0;  % end time
dt=2;  % regulation time bewteen each step
flag=1; 
N=25;  % number of search steps
%initial condition of the state 
if icon==1
   x0=[-1.9;0;0];   % banana function
else
   x0=[-10;10;0];   % another cost function
end
xhat(:,1)=x0(1:2);  % real regulated state
xsr(:,1)=x0(1:2);   % desired regulated state
Nx=0;          % counter of state
Nu=0;          % counter of control
Nt=0;          % counter of time
rho=0.4;       % constant in Armijo condition
w=0.5          % step size retraction factor

for ind=1:N    
    t1=t0+dt;  
        
    % steep descent algorithm    
    x1=x0(1);  % current location
    x2=x0(2);
    
    if icon==1
      
    % Banana Function
    [f,grad]=banana([x0(1),x0(2)]);  % obtain function value and gradient

    % perform an inexact line search satifiying Armijo condition
    % a maximum limit of 50 trial of step size is posted
    % ideally we should impose such a limitation
    alpha1=1; 
    for k=1:50     
        if banana([x1+alpha1*(-grad(1)),x2+alpha1*(-grad(2))]) <= f+rho*alpha1*(-grad.')*grad
           break;
        end
        alpha1=w*alpha1; 
    end
    
    else  
    % another cost function   
    grad=[10*x1+4*x2-14;2*x2+4*x1-6];
    alpha1=((-grad(1))^2+(-grad(2))^2)/(2*(5*(-grad(1))^2+(-grad(2))^2+4*(-grad(1))*(-grad(2))));
    end
    
    % obtained step length
    alpha2=alpha1;
    xs=[x1-alpha1*grad(1);x2-alpha2*grad(2)];   % ideal search destination
    xsr(:,end+1)=xs;
    
    % control gramian
    Wc(1,1)=quad(@ctrbgram11,0,t1-t0);
    Wc(1,2)=quad(@ctrbgram12,0,t1-t0);
    Wc(2,1)=quad(@ctrbgram21,0,t1-t0);
    Wc(2,2)=quad(@ctrbgram22,0,t1-t0);
    InvWc=inv(Wc);
    
    % solving the ode
    tspan=[t0 t1];  
    rand('state',0);
    [t,x]=ode23('ionlesc_steep_derivatives',tspan,x0);    
    
    for i=1:length(t)
        idx = find(tsave-t(i)==0);
        u(i)=usave(idx(length(idx)));
    end;

    
    % update
    x0=x(end,:)
    xhat(:,end+1)=x0(1:2);   % real regulated state
    x0=x0.'+0*rand(1);  % disturbing the regulated state
    
    t0=t1;
    xreal(Nx+1:Nx+length(x),:)=x;
    Nx=length(xreal)-1;
    ureal(Nu+1:Nu+length(u))=u;
    Nu=length(ureal)-1;    
    treal(Nt+1:Nt+length(t))=t;
    Nt=length(treal)-1;
    usave=[]; tsave=[];
end

% trajectory of the states
x1=xreal(:,1);
x2=xreal(:,2);
x3=xreal(:,3);

% trajectory of the output banana function
if icon==1
   y=100*(x2-x1.^2).^2+(1-x1).^2;
else
   y=5.*x1.^2+x2.^2+4.*x1.*x2-14*x1-6*x2+20;
end
figure 
plot(treal,y,'r','LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('output','FontSize',18,'FontWeight','bold');
title('Objective Function','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 

figure
plot(treal,x1,treal,x2,'r',treal,x3,'g','LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('states','FontSize',18,'FontWeight','bold');
legend('x_1','x_2','x_3');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
%axis([0 10 -1 1]

figure
plot(treal,ureal(1:length(treal)),'LineWidth',3);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('Input','FontSize',18,'FontWeight','bold');
grid on;  set(gca,'FontSize',12,'FontWeight','bold');  

if icon==1
% plot the contour of the banana function
[x1, x2]=meshgrid(-2:0.01:2, -1:0.01:3);
ros=100*(x2-x1.^2).^2+(1-x1).^2;
figure;
height=[0:0.5:2];
contour(x1,x2,ros,height);
hold on;
height=[2:5:20];
contour(x1,x2,ros,height);
height=[20:50:600];
contour(x1,x2,ros,height);
xlabel('x_1','FontSize',18,'FontWeight','bold');
ylabel('x_2','FontSize',18,'FontWeight','bold');
title('Contour of the Rosenbrock Function','FontSize',18,'FontWeight','bold');
hold on;
set(gca,'FontSize',12,'FontWeight','bold'); 
plot(1,1,'*','MarkerSize',10,'LineWidth',2);
else
% plot the contour of anthor cost function
x1=linspace(-15,15,100);
x2=x1;
[X1,X2]=meshgrid(x1,x2);
Z=5.*(X1.^2)+X2.^2+4.*X1.*X2-14.*X1-6.*X2+20;
figure
v= exp(0:0.2:10);
contour(X1,X2,Z,v);
title('Contour of the Quadratic Function','FontSize',18,'FontWeight','bold');
set(gca,'FontSize',12,'FontWeight','bold'); 
hold on;
end

plot(xsr(1,:),xsr(2,:),'o','MarkerEdgeColor','b','MarkerFaceColor',[.49 1 .63], 'MarkerSize',12,'LineWidth',3);
hold on
plot(xhat(1,:),xhat(2,:),'s','MarkerEdgeColor','m','MarkerFaceColor',[.49 1 .63], 'MarkerSize',12,'LineWidth',3);
hold on
plot(xreal(:,1),xreal(:,2),'r--','LineWidth',3);

xlabel('x_1','FontSize',18,'FontWeight','bold');
ylabel('x_2','FontSize',18,'FontWeight','bold');
set(gca,'FontSize',12,'FontWeight','bold'); 
text(-1.95,-0.1,'start point','FontSize',12,'FontWeight','bold'); 
text(1,1.1,'minimizer','FontSize',12,'FontWeight','bold'); 
text(-1.5,0.8,'state trajectory','FontSize',12,'FontWeight','bold'); 
 
